import 'package:dio/dio.dart';
import 'package:google_maps_flutter/google_maps_flutter.dart';
import 'package:razinsoft_rider/data/services/api/dio_client.dart';
import 'package:razinsoft_rider/domain/interfaces/driver_service_interface.dart';

import '../../core/config/api_endpoints.dart';

class DriverService implements IDriverService {
  final DioClient dioClient;

  DriverService({required this.dioClient});
  @override
  Future<Response> getDrivers({required LatLng? location}) async => dioClient.dio.get(
      ApiEndpoints.getDrivers,
      queryParameters: {
        'latitude': location!.latitude,
        'longitude': location.longitude,
      },
    );
}
